SET QUOTED_IDENTIFIER ON
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 155
      AND SKL.[COMMENT] = '013 Release 1 Fixes')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       155,
       'Build 5.1.1.155',
       '013 Release 1 Fixes **FAILED**')
GO

/***********************************************************************
 *
 * If any database fixes need to be performed against Release 1
 * put them in here. All other SQL files will be locked for editing.
 *
 ***********************************************************************/

 IF OBJECT_ID(N'[Ky_NETTaskGetAlarmDetails]',N'P')IS NOT NULL
	DROP PROCEDURE [Ky_NETTaskGetAlarmDetails]
GO 

CREATE procedure [Ky_NETTaskGetAlarmDetails]
 @ActionID	INT   
 
 /*This Procedure has been checked for SQL statement general standards/optimization on 24/11/2014 by Praveen Yadav.P          */
AS    
BEGIN    
SET NOCOUNT ON    
	DECLARE @Time AS INT     
	SET @Time= ( SELECT DYSTARTTIME FROM diary WHERE ACTIONID=@ActionID)--( SELECT CONVERT(VARCHAR, DATEADD(ms, 10 * (DYSTARTTIME - 1), CONVERT(VARCHAR, GETDATE(), 112)), 108) FROM diary WHERE ACTIONID=@ActionID)    
	SET @Time=(@Time+59999)/90000    
	 
	IF (@Time >=95)    
	BEGIN    
		SET @Time= 8639901     
	END    
	ELSE    
	BEGIN    
		SET @Time=@Time+1    
		SET @Time=@Time*90000    
		SET @Time=@Time+1    
	END    
     
	DECLARE @AlarmTime AS DATETIME     
	SET @AlarmTime=(SELECT 
						CONVERT(VARCHAR,(SELECT    
											CASE 
												WHEN 
													DATEPART(MINUTE,CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1), CONVERT(VARCHAR, GETDATE(), 112)), 108)) % 15 = 0    
												THEN 
													CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1), CONVERT(VARCHAR, GETDATE(), 112)), 108)    
												WHEN 
													DATEPART(MINUTE,CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1), CONVERT(VARCHAR, GETDATE(), 112)), 108)) % 15 < 10    
												THEN 
													DATEADD(MINUTE, -(DATEPART(MINUTE, CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1),CONVERT(VARCHAR, GETDATE(), 112)), 108)) % 15)
																	 ,CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1), CONVERT(VARCHAR, GETDATE(), 112)), 108))    
												ELSE
													DATEADD(MINUTE, 15 - DATEPART(MINUTE, CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1)
													,CONVERT(VARCHAR, GETDATE(), 112)), 108)) % 15, CONVERT(VARCHAR, DATEADD(ms, 10 * (@Time - 1),CONVERT(VARCHAR, GETDATE(), 112)), 108)) END
											),108)
					)    
	SELECT	
		CASECODE,ISNULL(TEXT1,'') AS 'TEXT1',
		CONVERT(NVARCHAR(11),DATE,106) AS [Date],
		--STUFF( RIGHT(CONVERT(VARCHAR,@AlarmTime, 109), 15 ), 7, 7, ' ' ) AS [Time]
		CONVERT(VARCHAR(5),@AlarmTime,108)  AS [Time]
	FROM 
		Diary 
	WHERE 
		ACTIONID=@ActionID    

	SELECT 
		A.HANDLER,
		B.Name,
		A.[OWNER]   
	FROM  
		DiaryDelegations A 
	LEFT OUTER JOIN 
		Handlers B 
	ON  
		A.HANDLER= B.CODE   
	WHERE 
		A.ACTIONID = @ActionID 
	ORDER BY
		A.OWNER DESC,
		A.ACTIONID ASC, 
		A.HANDLER ASC,
		A.ASSIGNNO ASC  

SET NOCOUNT OFF    
 END



GO

UPDATE SKL
   SET SKL.[COMMENT] = '013 Release 1 Fixes' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 155
   AND SKL.[COMMENT] = '013 Release 1 Fixes **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 157
      AND SKL.[COMMENT] = '013 Release 1 Fixes')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       157,
       'Build 5.1.1.157',
       '013 Release 1 Fixes **FAILED**')
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_GetDatabaseCompatibleVersionLog'
      AND SO.[type] = 'P')
BEGIN
  DROP PROCEDURE [dbo].[ky_GetDatabaseCompatibleVersionLog]
END
GO

CREATE PROCEDURE 
       [dbo].[ky_GetDatabaseCompatibleVersionLog]
AS
/******************************************************************************
 *
 * [dbo].[ky_GetDatabaseCompatibleVersionLog]
 *
 *
 ******************************************************************************/
BEGIN
  SELECT KSL.[timestamp],
         KSL.[CompatibleVersion],
         KSL.[COMMENT]
    FROM [dbo].[KYScriptLog] KSL
ORDER BY KSL.[MajorVersion] DESC,
         KSL.[MinorVersion] DESC,
         KSL.[Build] DESC,
         KSL.[Revision] DESC,
         KSL.[TimeStamp] DESC
END
GO

UPDATE SKL
   SET SKL.[COMMENT] = '013 Release 1 Fixes' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 157
   AND SKL.[COMMENT] = '013 Release 1 Fixes **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 159
      AND SKL.[COMMENT] = '013 Release 1 Fixes')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       159,
       'Build 5.1.1.159',
       '013 Release 1 Fixes **FAILED**')
GO

IF OBJECT_ID(N'ky_NETAddTimeDayBook',N'P')IS NOT NULL
    DROP PROCEDURE [dbo].[ky_NETAddTimeDayBook]
GO
 
CREATE PROCEDURE
       [dbo].[ky_NETAddTimeDayBook]
      (@Matter                VARCHAR(20),    
       @FeeEarner             VARCHAR(10),
       @Minutes               INT=0,
       @StopwatchStatus       INT=1,
       @RecordID              INT=0,
       @UpdateByPass          BIT=0,
       @DeleteByPass          BIT=0,
       @AddNew                BIT=0)
AS    
/*    
    
Created By : Praveen Yadav.P    
Date  : 28/04/2014    
Description  : ky_NETAddTimeDayBook is used to add new Timedaybook entry    
     
Last Updated: 04June2014 08:24 PM
              2014-12-15 Pino - Matter Code can be up to 20 characters.
     
*/    
BEGIN    
    
  IF(@UpdateByPass=0)
    BEGIN
    
        UPDATE     
         TimeDayBook    
        SET    
         StopwatchStatus=1    
        WHERE    
         FEEEARN=@FeeEarner  
    END      

  IF(@DeleteByPass=0)
    BEGIN
        IF(@Minutes=0)
            BEGIN 
                DELETE 
                    TimeDayBook 
                 WHERE  
                    FEEEARN=@FeeEarner  AND  ISNULL(TIME,0)=0  AND Matter<>'' AND TIMEORCHARGE='T'
            END    
        ELSE
            BEGIN
                DELETE 
                    TimeDayBook 
                 WHERE  
                    FEEEARN=@FeeEarner  AND  ISNULL(TIME,0)=0  AND Matter NOT IN ('' ,@Matter) AND TIMEORCHARGE='T'
            END 
   END
    
    IF(@RecordID<>0)
          BEGIN
            UPDATE     
                TimeDayBook    
               SET    
                StopwatchStatus=@StopwatchStatus ,  
                [TIME]=@Minutes ,
                Post='Y' 
               WHERE    
                RecordID=@RecordID 
                
                
                SELECT TOP 1 
                    RecordID,
                    ISNULL([TIME],0) AS [Minutes] 
                FROM 
                    TimeDayBook 
                WHERE 
                    RecordID=@RecordID 
          END
     ELSE
       BEGIN
                --UPDATE     
                -- TimeDayBook    
                --SET    
                -- StopwatchStatus=1    
                --WHERE    
                -- FEEEARN=@FeeEarner  
                 
         IF (NOT EXISTS(SELECT TOP 1 1 FROM TimeDayBook WHERE FEEEARN=@FeeEarner AND RTRIM(LTRIM(MATTER))=@Matter AND Post='Y' ) OR   @Matter='' OR @AddNew=1 )
                  BEGIN
                      INSERT INTO   
                           TimeDayBook     
                           (    
                            MATTER    
                           ,FEEEARN    
                           ,DATE    
                           ,TIME  
                           ,TASK    
                           ,TIMEORCHARGE
                           ,Post 
                           ,StopwatchStatus    
                           )    
                       VALUES    
                           (    
                            @Matter    
                           ,@FeeEarner    
                           ,CONVERT(VARCHAR(12),GETDATE(),112)
                           ,@Minutes   
                           ,''    
                           ,'T'
                           ,'Y'
                           ,@StopwatchStatus  
                           )    
                     
                     SELECT SCOPE_IDENTITY() AS RecordID,0 AS [Minutes]  
                 END
            ELSE
                BEGIN
                 
                        UPDATE     
                            TimeDayBook    
                        SET    
                            StopwatchStatus=@StopwatchStatus 
                            ,Post='Y' 
                        WHERE   RecordID= 
                            (SELECT TOP 1  RecordID FROM TimeDayBook WHERE
                              FEEEARN=@FeeEarner AND MATTER=@Matter AND TIMEORCHARGE='T' ORDER BY 
                            RecordID DESC )
                         
                        SELECT 
                            TOP 1 
                            RecordID,
                            ISNULL([TIME],0) AS [Minutes] 
                         FROM 
                            TimeDayBook 
                         WHERE 
                            FEEEARN=@FeeEarner AND MATTER=@Matter AND TIMEORCHARGE='T'   
                            --AND Post='Y' 
                        ORDER BY 
                            RecordID DESC
                 END
                 
        END        
END    
 
     
GO

IF OBJECT_ID(N'ky_NETGetMatterDatailsForTimeDayBook',N'P')IS NOT NULL
    DROP PROCEDURE [dbo].[ky_NETGetMatterDatailsForTimeDayBook]
GO

CREATE PROCEDURE
       [dbo].[ky_NETGetMatterDatailsForTimeDayBook]
      (@Matter VARCHAR(20))
AS 
/*
 
Created By : Praveen Yadav.P
Date  : 05/05/2014
Name  : ky_NETGetMatterDatailsForTimeDayBook
Description  : Used to get the Matter Details
 
Modification History
--------------------------
Modified By  :     PINO
Modified Date :    2014-12-15
Modification Note: Matter code can be up to 20 characters
 
*/
BEGIN
  SELECT MAT.[Code] AS [Matter],
         MAT.[Description],
         RTRIM(ISNULL(CON.[Name], '')) AS [Name],
         RTRIM(ISNULL(MAT.[Description], ''))  AS [MatterDecription]
    FROM [dbo].[matters] MAT
         LEFT OUTER JOIN [dbo].[Contacts] CON
                      ON CON.[Code] = MAT.[ClientCode]
   WHERE MAT.[Code] = @Matter
END
GO

UPDATE SKL
   SET SKL.[COMMENT] = '013 Release 1 Fixes' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 159
   AND SKL.[COMMENT] = '013 Release 1 Fixes **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 160
      AND SKL.[COMMENT] = '013 Release 1 Fixes')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       160,
       'Build 5.1.1.160',
       '013 Release 1 Fixes **FAILED**')
GO

--IF NOT EXISTS
--  (SELECT *
--     FROM SYS.[objects] SO
--    WHERE SO.[name] = 'KHDTSearchRequest'
--      AND SO.[type] = 'U')
--  BEGIN
--    CREATE TABLE 
--           [dbo].[KHDTSearchRequest]
--          ([Handler]             VARCHAR(10),
--           [IndexLocation]       VARCHAR(260),
--           [SearchRequest]       VARCHAR(MAX),
--           [SearchResult]        NVARCHAR(MAX),
--           CONSTRAINT PK_KHDTSearchRequest PRIMARY KEY CLUSTERED
--                     ([Handler]))
--  END
--GO

--IF EXISTS
--  (SELECT *
--     FROM SYS.[objects] SO
--    WHERE SO.[name] = 'ky_NETSPGetDTSearchRequest'
--      AND SO.[type] = 'P')
--  BEGIN
--    DROP PROCEDURE [dbo].[ky_NETSPGetDTSearchRequest]
--  END
--GO

--CREATE PROCEDURE
--       [dbo].[ky_NETSPGetDTSearchRequest]
--      (@Handler VARCHAR(10))
--AS
--BEGIN
--  SELECT [IndexLocation],
--         [SearchRequest]
--    FROM [dbo].[KHDTSearchRequest] DTR
--   WHERE DTR.[Handler] = @Handler
--END
--GO

--IF EXISTS
--  (SELECT *
--     FROM SYS.[objects] SO
--    WHERE SO.[name] = 'ky_NETSPMakeDTSearchRequest'
--      AND SO.[type] = 'P')
--  BEGIN
--    DROP PROCEDURE [dbo].[ky_NETSPMakeDTSearchRequest]
--  END
--GO

--CREATE PROCEDURE
--       [dbo].[ky_NETSPMakeDTSearchRequest]
--      (@Handler       VARCHAR(10),
--       @IndexLocation VARCHAR(260),
--       @Request       VARCHAR(MAX))
--AS
--BEGIN
--  DELETE DTR
--    FROM [dbo].[KHDTSearchRequest] DTR
--   WHERE DTR.[Handler] = @Handler

--  INSERT
--    INTO [dbo].[KHDTSearchRequest]
--        ([Handler],
--         [IndexLocation],
--         [SearchRequest])
--  VALUES(@Handler,
--         @IndexLocation,
--         @Request)
--END
--GO

--IF EXISTS
--  (SELECT *
--     FROM SYS.[objects] SO
--    WHERE SO.[name] = 'ky_NETSPSetDTSearchRequestResult'
--      AND SO.[type] = 'P')
--  BEGIN
--    DROP PROCEDURE [dbo].[ky_NETSPSetDTSearchRequestResult]
--  END
--GO

--CREATE PROCEDURE
--       [dbo].[ky_NETSPSetDTSearchRequestResult]
--      (@Handler VARCHAR(10),
--       @Result  NVARCHAR(MAX))
--AS
--BEGIN
--  DELETE DTR
--    FROM [dbo].[KHDTSearchRequest] DTR
--   WHERE DTR.[Handler] = @Handler

--  INSERT
--    INTO [dbo].[KHDTSearchRequest]
--        ([Handler],
--         [SearchResult])
--  VALUES(@Handler,
--         @Result)
--END
--GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'dtSearchIndexRegister'
      AND SO.[type] = 'U')
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_ID]
                     AND SC.[name] = 'LocalIndexPath'
        WHERE SO.[name] = 'dtSearchIndexRegister'
          AND SO.[type] = 'U')
      BEGIN
        ALTER TABLE [dbo].[dtSearchIndexRegister] ADD [LocalIndexPath] VARCHAR(260)
      END

    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_ID]
                     AND SC.[name] = 'LocalDTSearch'
        WHERE SO.[name] = 'dtSearchIndexRegister'
          AND SO.[type] = 'U')
      BEGIN
        ALTER TABLE [dbo].[dtSearchIndexRegister] ADD [LocalDTSearch] VARCHAR(260)
      END
  END
GO

IF EXISTS
  (SELECT TOP 1 1 
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETSPListDTIndices'
      AND SO.[type] = 'P')
BEGIN
  DROP PROCEDURE [dbo].[ky_NETSPListDTIndices]
END
GO

CREATE PROCEDURE
       [dbo].[ky_NETSPListDTIndices]
      (@KeyhouseOnly      VARCHAR(1))
AS
/*******************************************************************************

      ky_NETSPListDTIndices

      Lists all the DT Search Indices defined to the system

 *******************************************************************************/
BEGIN

  SELECT [ID],
         RTRIM(ISNULL(DIR.[IndexName], '')) AS [IndexName],
         CASE WHEN UNC.[UNC] IS NULL 
                   THEN RTRIM(ISNULL(DIR.[IndexPath], ''))
              ELSE UNC.[UNC] + SUBSTRING(RTRIM(ISNULL(DIR.[IndexPath], '')), 3, LEN(RTRIM(ISNULL(DIR.[IndexPath], ''))) - 2) END AS [IndexPath],

         RTRIM(ISNULL(DIR.[IndexType], '')) AS [IndexType],
         ISNULL(DIR.[IncludeByDefault], 0) AS [IncludeByDefault],
         RTRIM(ISNULL(DIR.[LocalIndexPAth], '')) AS [LocalIndexPath],
         RTRIM(ISNULL(DIR.[LocalDTSearch], '')) AS [LocalDTSearch]
    FROM [dbo].[dtSearchIndexRegister] DIR
         LEFT OUTER JOIN [dbo].[UNCAlias] UNC
                      ON SUBSTRING(DIR.[IndexPath], 2, 1) = ':'
                     AND UNC.[Drive] = SUBSTRING(DIR.[IndexPath], 1, 1)
   WHERE (   (ISNULL(@KeyhouseOnly, 'N') <> 'Y')
          OR (RTRIM(ISNULl(DIR.[IndexType], '')) = 'Keyhouse'))
ORDER BY CASE
         WHEN RTRIM(ISNULL([IndexType], '')) = 'Keyhouse'
              THEN 'A'
         ELSE 'B' END,
         [ID]

END
GO

IF EXISTS
  (SELECT TOP 1 1 
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETSPChangeDTIndex'
      AND SO.[type] = 'P')
BEGIN
  DROP PROCEDURE [dbo].[ky_NETSPChangeDTIndex]
END
GO

CREATE PROCEDURE
       [dbo].[ky_NETSPChangeDTIndex]
      (@IDV                VARCHAR(10),
       @INCLUDEBYDEFAULT   VARCHAR(1),
       @INDEXNAME          VARCHAR(MAX),
       @INDEXPATH          VARCHAR(MAX),
       @INDEXTYPE          VARCHAR(MAX),
       @LocalIndexPath     VARCHAR(260),
       @LocalDTSearch      VARCHAR(260))
AS
/*************************************************************************************************************
 *
 * ky_NETSPChangeDTIndex
 *
 *************************************************************************************************************/
BEGIN

DECLARE @ID INT

BEGIN TRY
  SET @ID = CONVERT(INT, @IDV)
END TRY
BEGIN CATCH
  SET @ID = 0
END CATCH

IF (@ID > 0)
  BEGIN
    UPDATE DIR
       SET DIR.[INCLUDEBYDEFAULT] = CASE WHEN ISNULL(@INCLUDEBYDEFAULT, '') = ''
                                              THEN DIR.[INCLUDEBYDEFAULT]
                                         WHEN @INCLUDEBYDEFAULT = '1'
                                              THEN 1
                                         ELSE 0 END,
           DIR.[INDEXNAME] = CASE WHEN ISNULL(@INDEXNAME, '') = ''
                                       THEN DIR.[INDEXNAME]
                                  ELSE @INDEXNAME END,
           DIR.[INDEXPATH] = CASE WHEN ISNULL(@INDEXPATH, '') = ''
                                       THEN DIR.[INDEXPATH]
                                  ELSE @INDEXPATH END,
           DIR.[INDEXTYPE] = CASE WHEN ISNULL(@INDEXTYPE, '') = ''
                                       THEN DIR.[INDEXTYPE]
                                  WHEN @INDEXTYPE = 'Keyhouse'
                                       THEN 'Keyhouse'
                                  WHEN @INDEXTYPE = 'Web'
                                       THEN 'Web'
                                  WHEN @INDEXTYPE = 'Folder'
                                       THEN 'Folder'
                                  WHEN @INDEXTYPE = 'Other'
                                       THEN 'Other'
                                  ELSE 'Other' END,
           DIR.[LocalIndexPath] = RTRIM(@LocalIndexPath),
           DIR.[LocalDTSearch] = RTRIM(@LocalDTSearch)
      FROM [dbo].[dtSearchIndexRegister] DIR
     WHERE DIR.[ID] = @ID
  END
ELSE
  BEGIN
    INSERT
      INTO [dbo].[dtSearchIndexRegister]
          ([ID],
           [INCLUDEBYDEFAULT],
           [INDEXNAME],
           [INDEXPATH],
           [INDEXTYPE],
           [LocalIndexPath],
           [LocalDTSearch])
    SELECT ISNULL(NID.[NewID], 0) + 1,
           NI.[INCLUDEBYDEFAULT],
           NI.[INDEXNAME],
           NI.[INDEXPATH],
           NI.[INDEXTYPE],
           NI.[LocalIndexPath],
           NI.[LocalDTSearch]
      FROM (SELECT CASE WHEN ISNULL(@INCLUDEBYDEFAULT, '') = '1'
                             THEN 1
                        ELSE 0 END AS [INCLUDEBYDEFAULT],
                   ISNULL(@INDEXNAME, '') AS [INDEXNAME],
                   ISNULL(@INDEXPATH, '') AS [INDEXPATH],
                   CASE WHEN ISNULL(@INDEXTYPE, '') = ''
                             THEN 'Other'
                        WHEN @INDEXTYPE = 'Keyhouse'
                             THEN 'Keyhouse'
                        WHEN @INDEXTYPE = 'Web'
                             THEN 'Web'
                        WHEN @INDEXTYPE = 'Folder'
                             THEN 'Folder'
                        WHEN @INDEXTYPE = 'Other'
                             THEN 'Other'
                        ELSE 'Other' END AS [INDEXTYPE],
                   RTRIM(@LocalIndexPath) AS [LocalIndexPath],
                   RTRIM(@LocalDTSearch) AS [LocalDTSearch]) NI
           CROSS APPLY (SELECT MAX(DXI.[ID]) AS [NewID]
                          FROM [dbo].[dtSearchIndexRegister] DXI) NID
           LEFT OUTER JOIN [dbo].[dtSearchIndexRegister] OI
                        ON OI.[INDEXNAME] = NI.[INDEXNAME]
                        OR OI.[INDEXPATH] = ni.[INDEXPATH]
     WHERE NI.[INDEXNAME] <> ''
       AND NI.[INDEXPATH] <> ''
       AND OI.[ID] IS NULL
  END

END
GO

--IF EXISTS
--  (SELECT *
--     FROM SYS.[objects] SO
--    WHERE SO.[name] = 'ky_NETSPGetLocalDTSearch'
--      AND SO.[type] = 'P')
--BEGIN
--  DROP PROCEDURE [dbo].[ky_NETSPGetLocalDTSearch]
--END
--GO

--CREATE PROCEDURE
--       [dbo].[ky_NETSPGetLocalDTSearch]
--      (@Handler       VARCHAR(10),
--       @IndexLocation VARCHAR(260),
--       @LocalDTSearch VARCHAR(260),
--       @Search        VARCHAR(MAX),
--       @TROnly        BIT,
--       @Stage         INT)
--AS
--BEGIN

--DECLARE @XML NVARCHAR(MAX)
--DECLARE @iXML INT
--DECLARE @COMMAND VARCHAR(300)

--IF (@Stage = 1)
--  BEGIN
--    EXEC [dbo].[ky_NETSPMakeDTSearchRequest] @Handler, @IndexLocation, @Search
--  END

--SET @COMMAND = @LocalDTSearch + ' ' + @Handler

--IF (@Stage = 2)
--  BEGIN
--    EXEC master..xp_cmdshell @COMMAND, [no_output]
--  END

--IF (@Stage = 3)
--  BEGIN
--    SELECT @XML = [SearchResult] 
--      FROM [dbo].[KHDTSearchRequest]
--     WHERE [Handler] = @Handler

--    SET @XML = RTRIM(ISNULL(@XML, ''))

--    IF (@XML = '')
--      BEGIN
--        SET @XML = '<?xml version="1.0" ?>
--                    <dtSearchResults></dtSearchResults>'
--      END

--    SET @XML = REPLACE(@XML, N' encoding="UTF-8"', N'')

--    --SET @XML = '<?xml version="1.0" ?>
--    --<dtSearchResults></dtSearchResults>'

--    EXEC sp_xml_preparedocument @iXML OUTPUT, @XML

--    IF ISNULL(@TROnly, 0) = 1
--      BEGIN
--        SELECT RES.[TrackReference]
--          FROM OPENXML(@iXML, 'dtSearchResults/Item', 2)
--                  WITH([TrackReference]               INT            'UserFields/TrackReference') RES
--      END
--    ELSE
--      BEGIN
--        SELECT RES.[FileName],
--               RES.[Location],
--               RES.[ShortName],
--               RES.[DisplayName],
--               CONVERT(DATETIME, REPLACE(REPLACE(RES.[Date], '-', ''), 'Z', '')) AS [Date],
--               CONVERT(DATETIME, REPLACE(REPLACE(RES.[CreateDate], '-', ''), 'Z', '')) AS [CreateDate],
--               RES.[TrackReference],
--               RES.[ClientCode],
--               RES.[ClientDescription],
--               RES.[MatterCode],
--               RES.[MatterDescription],
--               CONVERT(DATETIME, REPLACE(REPLACE(RES.[DocumentAccessDate], '-', ''), 'Z', '')) AS [DocumentAccessDate],
--               CONVERT(DATETIME, REPLACE(REPLACE(RES.[DocumentCreateDate], '-', ''), 'Z', '')) AS [DocumentCreateDate],
--               CONVERT(DATETIME, REPLACE(REPLACE(RES.[DocumentModifyDate], '-', ''), 'Z', '')) AS [DocumentModifyDate],
--               RES.[DocumentClass],
--               RES.[DocumentClassDescription],
--               RES.[DocumentDisplayName],
--               RES.[DocumentType],
--               RES.[EmailFrom],
--               RES.[EmailTo],
--               RES.[EmailSource],
--               RES.[EmailSubject],
--               RES.[User1],
--               RES.[User2],
--               RES.[User3],
--               RES.[OldRef],
--               RES.[YourRef]
--          FROM OPENXML(@iXML, 'dtSearchResults/Item', 2)
--                  WITH([FileName]                     VARCHAR(260)   'Filename',
--                       [Location]                     VARCHAR(260)   'Location',
--                       [ShortName]                    VARCHAR(100)   'ShortName',
--                       [DisplayName]                  VARCHAR(100)   'DisplayName',
--                       [Date]                         VARCHAR(30)    'Date',
--                       [CreateDate]                   VARCHAR(30)    'CreateDate',
--                       [TrackReference]               INT            'UserFields/TrackReference',
--                       [ClientCode]                   VARCHAR(10)    'UserFields/ClientCode',
--                       [ClientDescription]            VARCHAR(200)   'UserFields/ClientDescription',
--                       [MatterCode]                   VARCHAR(10)    'UserFields/MatterCode',
--                       [MatterDescription]            VARCHAR(200)   'UserFields/MatterDescription',
--                       [DocumentAccessDate]           VARCHAR(30)    'UserFields/DocumentAccessDate',
--                       [DocumentCreateDate]           VARCHAR(30)    'UserFields/DocumentCreateDate',
--                       [DocumentModifyDate]           VARCHAR(30)    'UserFields/DocumentModifyDate',
--                       [DocumentClass]                VARCHAR(10)    'UserFields/DocumentClass',
--                       [DocumentClassDescription]     VARCHAR(100)   'UserFields/DocumentClassDescription',
--                       [DocumentDisplayName]          VARCHAR(200)   'UserFields/DocumentDisplayName',
--                       [DocumentType]                 VARCHAR(10)    'UserFields/DocumentType',
--                       [EmailFrom]                    VARCHAR(200)   'UserFields/EmailFrom',
--                       [EmailTo]                      VARCHAR(2000)  'UserFields/EmailTo',
--                       [EmailSource]                  VARCHAR(20)    'UserFields/EmailSource',
--                       [EmailSubject]                 VARCHAR(1000)  'UserFields/EmailSubject',
--                       [User1]                        VARCHAR(20)    'UserFields/User1',
--                       [User2]                        VARCHAR(20)    'UserFields/User2',
--                       [User3]                        VARCHAR(20)    'UserFields/User3',
--                       [OldRef]                       VARCHAR(20)    'UserFields/OldRef',
--                       [YourRef]                      VARCHAR(100)   'UserFields/YourRef') RES
--      END

--    EXEC sp_xml_removedocument @iXML
--  END

--END
--GO

UPDATE SKL
   SET SKL.[COMMENT] = '013 Release 1 Fixes' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 160
   AND SKL.[COMMENT] = '013 Release 1 Fixes **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 165
      AND SKL.[COMMENT] = '013 Release 1 Fixes')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       165,
       'Build 5.1.1.165',
       '013 Release 1 Fixes **FAILED**')
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'KHDTSearchRequest'
      AND SO.[type] = 'U')
  BEGIN
    DROP TABLE [dbo].[KHDTSearchRequest]
  END
GO

IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'KHDTSearchRequest'
      AND SO.[type] = 'U')
  BEGIN
    CREATE TABLE 
           [dbo].[KHDTSearchRequest]
          ([Handler]             VARCHAR(10),
           [IndexLocation]       VARCHAR(260),
           [SearchRequest]       VARCHAR(MAX),
           [SearchResult]        NVARCHAR(MAX),
           [MaxResult]           INT,
           [MaxResultExceeded]   BIT,
           CONSTRAINT PK_KHDTSearchRequest PRIMARY KEY CLUSTERED
                     ([Handler]))
  END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETSPGetDTSearchRequest'
      AND SO.[type] = 'P')
  BEGIN
    DROP PROCEDURE [dbo].[ky_NETSPGetDTSearchRequest]
  END
GO

CREATE PROCEDURE
       [dbo].[ky_NETSPGetDTSearchRequest]
      (@Handler VARCHAR(10))
AS
BEGIN
  SELECT [IndexLocation],
         [SearchRequest],
         [MaxResult]
    FROM [dbo].[KHDTSearchRequest] DTR
   WHERE DTR.[Handler] = @Handler
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETSPMakeDTSearchRequest'
      AND SO.[type] = 'P')
  BEGIN
    DROP PROCEDURE [dbo].[ky_NETSPMakeDTSearchRequest]
  END
GO

CREATE PROCEDURE
       [dbo].[ky_NETSPMakeDTSearchRequest]
      (@Handler       VARCHAR(10),
       @IndexLocation VARCHAR(260),
       @Request       VARCHAR(MAX),
       @MaxResult     INT)
AS
BEGIN
  DELETE DTR
    FROM [dbo].[KHDTSearchRequest] DTR
   WHERE DTR.[Handler] = @Handler

  INSERT
    INTO [dbo].[KHDTSearchRequest]
        ([Handler],
         [IndexLocation],
         [SearchRequest],
         [MaxResult])
  VALUES(@Handler,
         @IndexLocation,
         @Request,
         @MaxResult)
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETSPSetDTSearchRequestResult'
      AND SO.[type] = 'P')
  BEGIN
    DROP PROCEDURE [dbo].[ky_NETSPSetDTSearchRequestResult]
  END
GO

CREATE PROCEDURE
       [dbo].[ky_NETSPSetDTSearchRequestResult]
      (@Handler           VARCHAR(10),
       @Result            NVARCHAR(MAX),
       @MaxResultExceeded BIT)
AS
BEGIN
  DELETE DTR
    FROM [dbo].[KHDTSearchRequest] DTR
   WHERE DTR.[Handler] = @Handler

  INSERT
    INTO [dbo].[KHDTSearchRequest]
        ([Handler],
         [SearchResult],
         [MaxResultExceeded])
  VALUES(@Handler,
         @Result,
         @MaxResultExceeded)
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETSPGetLocalDTSearch'
      AND SO.[type] = 'P')
BEGIN
  DROP PROCEDURE [dbo].[ky_NETSPGetLocalDTSearch]
END
GO

CREATE PROCEDURE
       [dbo].[ky_NETSPGetLocalDTSearch]
      (@Handler       VARCHAR(10),
       @IndexLocation VARCHAR(260),
       @LocalDTSearch VARCHAR(260),
       @Search        VARCHAR(MAX),
       @MaxResult     INT,
       @TROnly        BIT,
       @Stage         INT)
AS
BEGIN

DECLARE @XML NVARCHAR(MAX)
DECLARE @MaxResultExceeded BIT
DECLARE @iXML INT
DECLARE @COMMAND VARCHAR(300)

IF (@Stage = 1)
  BEGIN
    EXEC [dbo].[ky_NETSPMakeDTSearchRequest] @Handler, @IndexLocation, @Search, @MaxResult
  END

SET @COMMAND = @LocalDTSearch + ' ' + @Handler

IF (@Stage = 2)
  BEGIN
    EXEC master..xp_cmdshell @COMMAND, [no_output]
  END

IF (@Stage = 3)
  BEGIN
    SELECT @XML = SRQ.[SearchResult],
           @MaxResultExceeded = SRQ.[MaxResultExceeded]
      FROM [dbo].[KHDTSearchRequest] SRQ
     WHERE SRQ.[Handler] = @Handler

    SET @XML = RTRIM(ISNULL(@XML, ''))

    IF (@XML = '')
      BEGIN
        SET @XML = '<?xml version="1.0" ?>
                    <dtSearchResults></dtSearchResults>'
      END

    SET @XML = REPLACE(@XML, N' encoding="UTF-8"', N'')

    --SET @XML = '<?xml version="1.0" ?>
    --<dtSearchResults></dtSearchResults>'

    EXEC sp_xml_preparedocument @iXML OUTPUT, @XML

    IF ISNULL(@TROnly, 0) = 1
      BEGIN
        SELECT RES.[TrackReference]
          FROM OPENXML(@iXML, 'dtSearchResults/Item', 2)
                  WITH([TrackReference]               INT            'UserFields/TrackReference') RES
      END
    ELSE
      BEGIN
        SELECT RES.[FileName],
               RES.[Location],
               RES.[ShortName],
               RES.[DisplayName],
               CONVERT(DATETIME, REPLACE(REPLACE(RES.[Date], '-', ''), 'Z', '')) AS [Date],
               CONVERT(DATETIME, REPLACE(REPLACE(RES.[CreateDate], '-', ''), 'Z', '')) AS [CreateDate],
               RES.[TrackReference],
               RES.[ClientCode],
               RES.[ClientDescription],
               RES.[MatterCode],
               RES.[MatterDescription],
               CONVERT(DATETIME, REPLACE(REPLACE(RES.[DocumentAccessDate], '-', ''), 'Z', '')) AS [DocumentAccessDate],
               CONVERT(DATETIME, REPLACE(REPLACE(RES.[DocumentCreateDate], '-', ''), 'Z', '')) AS [DocumentCreateDate],
               CONVERT(DATETIME, REPLACE(REPLACE(RES.[DocumentModifyDate], '-', ''), 'Z', '')) AS [DocumentModifyDate],
               RES.[DocumentClass],
               RES.[DocumentClassDescription],
               RES.[DocumentDisplayName],
               RES.[DocumentType],
               RES.[EmailFrom],
               RES.[EmailTo],
               RES.[EmailSource],
               RES.[EmailSubject],
               RES.[User1],
               RES.[User2],
               RES.[User3],
               RES.[OldRef],
               RES.[YourRef],
               @MaxResultExceeded AS [MaxResultExceeded]
          FROM OPENXML(@iXML, 'dtSearchResults/Item', 2)
                  WITH([FileName]                     VARCHAR(260)   'Filename',
                       [Location]                     VARCHAR(260)   'Location',
                       [ShortName]                    VARCHAR(100)   'ShortName',
                       [DisplayName]                  VARCHAR(100)   'DisplayName',
                       [Date]                         VARCHAR(30)    'Date',
                       [CreateDate]                   VARCHAR(30)    'CreateDate',
                       [TrackReference]               INT            'UserFields/TrackReference',
                       [ClientCode]                   VARCHAR(10)    'UserFields/ClientCode',
                       [ClientDescription]            VARCHAR(200)   'UserFields/ClientDescription',
                       [MatterCode]                   VARCHAR(10)    'UserFields/MatterCode',
                       [MatterDescription]            VARCHAR(200)   'UserFields/MatterDescription',
                       [DocumentAccessDate]           VARCHAR(30)    'UserFields/DocumentAccessDate',
                       [DocumentCreateDate]           VARCHAR(30)    'UserFields/DocumentCreateDate',
                       [DocumentModifyDate]           VARCHAR(30)    'UserFields/DocumentModifyDate',
                       [DocumentClass]                VARCHAR(10)    'UserFields/DocumentClass',
                       [DocumentClassDescription]     VARCHAR(100)   'UserFields/DocumentClassDescription',
                       [DocumentDisplayName]          VARCHAR(200)   'UserFields/DocumentDisplayName',
                       [DocumentType]                 VARCHAR(10)    'UserFields/DocumentType',
                       [EmailFrom]                    VARCHAR(200)   'UserFields/EmailFrom',
                       [EmailTo]                      VARCHAR(2000)  'UserFields/EmailTo',
                       [EmailSource]                  VARCHAR(20)    'UserFields/EmailSource',
                       [EmailSubject]                 VARCHAR(1000)  'UserFields/EmailSubject',
                       [User1]                        VARCHAR(20)    'UserFields/User1',
                       [User2]                        VARCHAR(20)    'UserFields/User2',
                       [User3]                        VARCHAR(20)    'UserFields/User3',
                       [OldRef]                       VARCHAR(20)    'UserFields/OldRef',
                       [YourRef]                      VARCHAR(100)   'UserFields/YourRef') RES
      END

    EXEC sp_xml_removedocument @iXML
  END

IF (@Stage = 4)
  BEGIN
    SELECT @XML = SRQ.[SearchResult],
           @MaxResultExceeded = SRQ.[MaxResultExceeded]
      FROM [dbo].[KHDTSearchRequest] SRQ
     WHERE SRQ.[Handler] = @Handler

    SET @XML = RTRIM(ISNULL(@XML, ''))

    IF (@XML = '')
      BEGIN
        SET @XML = '<?xml version="1.0" ?>
                    <dtSearchResults></dtSearchResults>'
      END

    SET @XML = REPLACE(@XML, N' encoding="UTF-8"', N'')

    SELECT @MaxResultExceeded AS [MaxResultExceeded], @XML AS [Result]
  END
END
GO

UPDATE SKL
   SET SKL.[COMMENT] = '013 Release 1 Fixes' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 165
   AND SKL.[COMMENT] = '013 Release 1 Fixes **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO

